<?php
session_start(); // Memulai session untuk menyimpan data scan

// Inisialisasi array untuk menyimpan hasil scan
if (!isset($_SESSION['scans'])) {
    $_SESSION['scans'] = [];
}

// Menghapus data scan jika tombol clear ditekan
if (isset($_POST['clear'])) {
    unset($_SESSION['scans']); // Menghapus data dari session
    // Redirect untuk menghindari pengiriman ulang form
    header("Location: index.php");
    exit();
}

// Proses scan jika data QR Code diterima
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['qrCode'])) {
    $url = $_POST['qrCode'];
    $xmlData = simplexml_load_file($url);
    if ($xmlData !== false) {
        // Menyimpan data ke dalam array
        $data = [
            'kdJenisTransaksi' => (string)$xmlData->kdJenisTransaksi,
            'fgPengganti' => (string)$xmlData->fgPengganti,
            'nomorFaktur' => (string)$xmlData->nomorFaktur,
            'tanggalFaktur' => (string)$xmlData->tanggalFaktur,
            'npwpPenjual' => (string)$xmlData->npwpPenjual,
            'namaPenjual' => (string)$xmlData->namaPenjual,
            'detailTransaksi' => $xmlData->detailTransaksi
        ];
        
        // Menyimpan data ke session
        foreach ($data['detailTransaksi'] as $detail) {
            $_SESSION['scans'][] = [
                'kdJenisTransaksi' => $data['kdJenisTransaksi'],
                'fgPengganti' => $data['fgPengganti'],
                'nomorFaktur' => $data['nomorFaktur'],
                'tanggalFaktur' => $data['tanggalFaktur'],
                'npwpPenjual' => $data['npwpPenjual'],
                'namaPenjual' => $data['namaPenjual'],
                'namaBarang' => (string)$detail->nama, // Menyimpan nama barang
                'hargaSatuan' => (string)$detail->hargaSatuan,
                'jumlahBarang' => (string)$detail->jumlahBarang,
                'hargaTotal' => (string)$detail->hargaTotal,
                'diskon' => (string)$detail->diskon,
                'dpp' => (string)$detail->dpp,
                'ppn' => (string)$detail->ppn,
                'masaPajak' => date('n', strtotime($data['tanggalFaktur'])), // Mengambil bulan dari tanggal
                'tahunPajak' => date('Y', strtotime($data['tanggalFaktur'])) // Mengambil tahun dari tanggal
            ];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Scan QR Code Faktur Pajak</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="instascan.min.js"></script> <!-- Load the Instascan library -->
    <style>
        #preview {
            width: 100%;
            max-width: 300px;
            border: 1px solid #ccc;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2>Scan QR Code Faktur Pajak</h2>
        <video id="preview" autoplay></video> <!-- Video element for camera feed -->
        <form id="form1" method="POST" action="index.php">
            <input type="hidden" id="kode" name="qrCode"> <!-- Hidden input for scanned QR code -->
            <button type="submit" class="btn btn-primary">Submit</button>
            <button type="submit" name="clear" class="btn btn-danger">Clear</button>
        </form>

        <h3>Hasil Scan</h3>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>No. Urut</th>
                    <th> FM</th>
                    <th>KD_JENIS_TRANSAKSI</th>
                    <th>FG_PENGGANTI</th>
                    <th>NOMOR_FAKTUR</th>
                    <th>MASA_PAJAK</th>
                    <th> TAHUN_PAJAK</th>
                    <th>TANGGAL_FAKTUR</th>
                    <th>NPWP</th>
                    <th>NAMA PENJUAL</th>
                    <th>NAMA BARANG</th>
                    <th>Harga Satuan</th>
                    <th>Jumlah Barang</th>
                    <th>Harga Total</th >
                    <th>Diskon</th>
                    <th>DPP</th>
                    <th>PPN</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $no = 1;
                foreach ($_SESSION['scans'] as $scan) {
                    echo '<tr>';
                    echo '<td>' . $no . '</td>';
                    echo '<td>FM</td>';
                    echo '<td>' . $scan['kdJenisTransaksi'] . '</td>';
                    echo '<td>' . $scan['fgPengganti'] . '</td>';
                    echo '<td>' . $scan['nomorFaktur'] . '</td>';
                    echo '<td>' . $scan['masaPajak'] . '</td>';
                    echo '<td>' . $scan['tahunPajak'] . '</td>';
                    echo '<td>' . $scan['tanggalFaktur'] . '</td>';
                    echo '<td>' . $scan['npwpPenjual'] . '</td>';
                    echo '<td>' . $scan['namaPenjual'] . '</td>';
                    echo '<td>' . $scan['namaBarang'] . '</td>';
                    echo '<td>' . $scan['hargaSatuan'] . '</td>';
                    echo '<td>' . $scan['jumlahBarang'] . '</td>';
                    echo '<td>' . $scan['hargaTotal'] . '</td>';
                    echo '<td>' . $scan['diskon'] . '</td>';
                    echo '<td>' . $scan['dpp'] . '</td>';
                    echo '<td>' . $scan['ppn'] . '</td>';
                    echo '</tr>';
                    $no++;
                }
                ?>
            </tbody>
        </table>
        <form method="POST" action="export.php">
            <button type="submit" class="btn btn-success">Export ke Excel</button>
        </form>
    </div>

    <script type="text/javascript">
        // Create a new scanner instance
        let scanner = new Instascan.Scanner({ video: document.getElementById('preview') });

        // Get available cameras
        Instascan.Camera.getCameras().then(function (cameras) {
            if (cameras.length > 0) {
                // Start the scanner with the first available camera
                scanner.start(cameras[0]);
            } else {
                alert("No cameras found.");
            }
        }).catch(function (e) {
            console.error(e);
        });

        // Listen for the scan event
        scanner.addListener('scan', function (content) {
            document.getElementById("kode").value = content; // Set the scanned code to the hidden input
            document.getElementById("form1").submit(); // Submit the form
        });
    </script>
</body>
</html>