<!-- ini dari yang lain -->
<?php
session_start(); // Memulai session untuk menyimpan data scan

// Inisialisasi array untuk menyimpan hasil scan
if (!isset($_SESSION['scans'])) {
    $_SESSION['scans'] = [];
}

// Menghapus data scan jika tombol clear ditekan
if (isset($_POST['clear'])) {
    unset($_SESSION['scans']); // Menghapus data dari session
    // Redirect untuk menghindari pengiriman ulang form
    header("Location: index.php");
    exit();
}

// Proses scan jika tombol scan ditekan
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['qrCode'])) {
    $url = $_POST['qrCode'];
    $xmlData = simplexml_load_file($url);
    if ($xmlData !== false) {
        // Mengambil tanggal dari XML
        $tanggalFaktur = (string)$xmlData->tanggalFaktur; // Ambil tanggal dari XML
        list($day, $month, $year) = explode('/', $tanggalFaktur); // Pecah tanggal menjadi hari, bulan, tahun

        // Menyimpan data ke dalam array
        $data = [
            'kdJenisTransaksi' => (string)$xmlData->kdJenisTransaksi,
            'fgPengganti' => (string)$xmlData->fgPengganti,
            'referensi' => (string)$xmlData->referensi,
            'nomorFaktur' => (string)$xmlData->nomorFaktur,
            'tanggalFaktur' => $tanggalFaktur,
            'npwpPenjual' => (string)$xmlData->npwpPenjual,
            'namaPenjual' => (string)$xmlData->namaPenjual,
            'detailTransaksi' => $xmlData->detailTransaksi,
            'masaPajak' => str_pad((int)$month, 2, '0', STR_PAD_LEFT), // Mengambil bulan dari tanggal dan memastikan 2 digit
            'tahunPajak' => (int)$year // Mengambil tahun dari tanggal
            
        ];
        
        // Menyimpan data ke session
        foreach ($data['detailTransaksi'] as $detail) {
            $_SESSION['scans'][] = [
                'kdJenisTransaksi' => $data['kdJenisTransaksi'],
                'fgPengganti' => $data['fgPengganti'],
                'referensi' => $data['referensi'],
                'nomorFaktur' => $data['nomorFaktur'],
                'tanggalFaktur' => $data['tanggalFaktur'],
                'npwpPenjual' => $data['npwpPenjual'],
                'namaPenjual' => $data['namaPenjual'],
                'namaBarang' => (string)$detail->nama, // Menyimpan nama barang
                'hargaSatuan' => (string)$detail->hargaSatuan,
                'jumlahBarang' => (string)$detail->jumlahBarang,
                'hargaTotal' => (string)$detail->hargaTotal,
                'diskon' => (string)$detail->diskon,
                'dpp' => (string)$detail->dpp,
                'ppn' => (string)$detail->ppn,
                'masaPajak' => str_pad((int)$month, 2, '0', STR_PAD_LEFT), // Mengambil bulan dari tanggal dan memastikan 2 digit
                'tahunPajak' => (int)$year, // Mengambil tahun dari tanggal
                
            ];
        }
    } else {
        // Jika XML tidak dapat dimuat, Anda bisa menambahkan pesan error
        echo "Gagal memuat data dari URL yang diberikan.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Scan QR Code Faktur Pajak</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <h2>Scan QR Code Faktur Pajak</h2>
        <form method="POST" action="index.php">
            <div class="form-group">
                <label for="qrCode">Masukkan URL QR Code:</label>
                <input type="text" class="form-control" id="qrCode" name="qrCode" required>
            </div>
            <button type="submit" class="btn btn-primary">Scan</button>
            <button type="submit" class="btn btn-danger" name="clear">Clear</button>
        </form>
        <h3 class="mt-4">Data Scan</h3>
        <table class="table">
            <thead>
                <tr>
                    <th>Kode Jenis Transaksi</th>
                    <th>Nomor Faktur</th>
                    <th>Masa Pajak</th>
                    <th>Referensi</th>
                    <th>Tahun Pajak</th>
                    <th>Tanggal Faktur</th>
                    <th>NPWP Penjual</th>
                    <th>Nama Penjual</th>
                    <th>Nama Barang</th>
                    <th>Harga Satuan</th>
                    <th>Jumlah Barang</th>
                    <th>Harga Total</th>
                    <th>Diskon</th>
                    <th>DPP</th>
                    <th>PPN</th>
                    
                </tr>
            </thead>
            <tbody>
                <?php if (isset($_SESSION['scans'])): ?>
                    <?php foreach ($_SESSION['scans'] as $scan): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($scan['kdJenisTransaksi']); ?></td>
                            <td><?php echo htmlspecialchars($scan['nomorFaktur']); ?></td>
                            <td><?php echo htmlspecialchars($scan['masaPajak']); ?></td>
                            <td><?php echo htmlspecialchars($scan['referensi']); ?></td>   
                            <td><?php echo htmlspecialchars($scan['tahunPajak']); ?></td>
                            <td><?php echo htmlspecialchars($scan['tanggalFaktur']); ?></td>
                            <td><?php echo htmlspecialchars($scan['npwpPenjual']); ?></td>
                            <td><?php echo htmlspecialchars($scan['namaPenjual']); ?></td>
                            <td><?php echo htmlspecialchars($scan['namaBarang']); ?></td>
                            <td><?php echo htmlspecialchars($scan['hargaSatuan']); ?></td>
                            <td><?php echo htmlspecialchars($scan['jumlahBarang']); ?></td>
                            <td><?php echo htmlspecialchars($scan['hargaTotal']); ?></td>
                            <td><?php echo htmlspecialchars($scan['diskon']); ?></td>
                            <td><?php echo htmlspecialchars($scan['dpp']); ?></td>
                            <td><?php echo htmlspecialchars($scan['ppn']); ?></td>
                                                      
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="14" class="text-center">Tidak ada data yang tersedia.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <form method="POST" action="export.php">
            <button type="submit" class="btn btn-success">Export ke Excel</button>
        </form>
    </div>
</body>
</html> 