<?php
session_start(); // Memulai session untuk menyimpan data scan

// Inisialisasi array untuk menyimpan hasil scan
if (!isset($_SESSION['scans'])) {
    $_SESSION['scans'] = [];
}

// Menghapus data scan jika tombol clear ditekan
if (isset($_POST['clear'])) {
    unset($_SESSION['scans']); // Menghapus data dari session
    // Redirect untuk menghindari pengiriman ulang form
    header("Location: index.php");
    exit();
}

// Proses scan jika tombol scan ditekan
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['qrCode'])) {
    $url = $_POST['qrCode'];
    $xmlData = simplexml_load_file($url);
    if ($xmlData !== false) {
        // Mengambil tanggal dari XML
        $tanggalFaktur = (string)$xmlData->tanggalFaktur; // Ambil tanggal dari XML
        list($day, $month, $year) = explode('/', $tanggalFaktur); // Pecah tanggal menjadi hari, bulan, tahun

        // Menyimpan data ke dalam array
        $data = [
            'kdJenisTransaksi' => (string)$xmlData->kdJenisTransaksi,
            'fgPengganti' => (string)$xmlData->fgPengganti,
            'nomorFaktur' => (string)$xmlData->nomorFaktur,
'referensi' => (string)$xmlData->referensi,
            'tanggalFaktur' => $tanggalFaktur,
            'npwpPenjual' => (string)$xmlData->npwpPenjual,
            'namaPenjual' => (string)$xmlData->namaPenjual,
            'detailTransaksi' => $xmlData->detailTransaksi,
            'masaPajak' => (string)$month, // Mengambil bulan dari tanggal
            'tahunPajak' => (string)$year // Mengambil tahun dari tanggal
        ];
        
        // Menyimpan data ke session
        foreach ($data['detailTransaksi'] as $detail) {
            $_SESSION['scans'][] = [
                'kdJenisTransaksi' => $data['kdJenisTransaksi'],
                'fgPengganti' => $data['fgPengganti'],
                'nomorFaktur' => $data['nomorFaktur'],
'referensi'=>$data['referensi'],
                'tanggalFaktur' => $data['tanggalFaktur'],
                'npwpPenjual' => $data['npwpPenjual'],
                'namaPenjual' => $data['namaPenjual'],
                'namaBarang' => (string)$detail->nama, // Menyimpan nama barang
                'hargaSatuan' => (string)$detail->hargaSatuan,
                'jumlahBarang' => (string)$detail->jumlahBarang,
                'hargaTotal' => (string)$detail->hargaTotal,
                'diskon' => (string)$detail->diskon,
                'dpp' => (string)$detail->dpp,
                'ppn' => (string)$detail->ppn,
                'masaPajak' => (string)$month, // Mengambil bulan dari tanggal
                'tahunPajak' => (string)$year // Mengambil tahun dari tanggal
            ];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Scan QR Code Faktur Pajak</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <h2>Scan QR Code Faktur Pajak</h2>
        <form method="POST" action="index.php">
            <div class="form-group">
                <label for="qrCode">Masukkan URL QR Code:</label>
                <input type="text" class="form-control" id="qrCode" name="qrCode" required>
            </div>
            <button type="submit" class="btn btn-primary">Scan</button>
            <button type="submit" name="clear" class="btn btn-danger">Clear</button>
        </form>

        <h3>Hasil Scan</h3>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>No. Urut</th>
                    <th>FM </th>
                    <th>KD_JENIS_TRANSAKSI</th>
                    <th>FG_PENGGANTI</th>
<th>REFERENSI</th>
                    <th>NOMOR_FAKTUR</th>
                    <th>MASA_PAJAK</th>
                    <th>TAHUN_PAJAK</th>
                    <th>TANGGAL_FAKTUR</th>
                    <th>NPWP</th>
                    <th>NAMA PENJUAL</th>
                    <th>NAMA BARANG</th>
                    <th>Harga Satuan</th>
                    <th>Jumlah Barang</th>
                    <th>Harga Total</th>
                    <th>Diskon</th>
                    <th>DPP</th>
                    <th>PPN</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $no = 1;
                foreach ($_SESSION['scans'] as $scan) {
                    echo '<tr>';
                    echo '<td>' . $no . '</td>';
                    echo '<td>FM</td>';
                    echo '<td>' . $scan['kdJenisTransaksi'] . '</td>';
                    echo '<td>' . $scan['fgPengganti'] . '</td>';
echo '<td>\''.$scan['referensi'].'</td>';
                    echo '<td>\'' . $scan['nomorFaktur'] . '</td>';
                    echo '<td>\'' . $scan['masaPajak'] . '</td>';
                    echo '<td>\'' . $scan['tahunPajak'] . '</td>';
                    echo '<td>' . $scan['tanggalFaktur'] . '</td>';
                    echo '<td>\'' . $scan['npwpPenjual'] . '</td>';
                    echo '<td>' . $scan['namaPenjual'] . '</td>';
                    echo '<td>' . $scan['namaBarang'] . '</td>';
                    echo '<td>' . $scan['hargaSatuan'] . '</td>';
                    echo '<td>' . $scan['jumlahBarang'] . '</td>';
                    echo '<td>' . $scan['hargaTotal'] . '</td>';
                    echo '<td>' . $scan['diskon'] . '</td>';
                    echo '<td>' . $scan['dpp'] . '</td>';
                    echo '<td>' . $scan['ppn'] . '</td>';
                    echo '</tr>';
                    $no++;
                }
                ?>
            </tbody>
        </table>
        <form method="POST" action="export.php">
            <button type="submit" class="btn btn-success">Export ke Excel</button>
        </form>
    </div>
</body>
</html>
